import 'package:admin_desktop/app_constants.dart';
import 'package:admin_desktop/application/bookings/create/create_booking_notifier.dart';
import 'package:admin_desktop/application/bookings/create/create_booking_state.dart';
import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter/material.dart';
import 'package:admin_desktop/application/bookings/create/create_booking_provider.dart';
import 'package:admin_desktop/domain/models/models.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:remixicon_updated/remixicon_updated.dart';
import 'package:admin_desktop/application/bookings/booking_provider.dart';
import 'booking_payment_modal.dart';
import 'widgets/price_item.dart';

class AddNotePage extends ConsumerStatefulWidget {
  const AddNotePage({super.key});

  @override
  ConsumerState<AddNotePage> createState() => _AddNotePageState();
}

class _AddNotePageState extends ConsumerState<AddNotePage> {
  final _formKey = GlobalKey<FormState>();

  @override
  void initState() {
    WidgetsBinding.instance.addPostFrameCallback((_) {
      ref.read(createBookingProvider.notifier).calculateBooking(
            context: context,
          );
    });
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    final state = ref.watch(createBookingProvider);
    final notifier = ref.read(createBookingProvider.notifier);
    return KeyboardDismisser(
      child: Scaffold(
        backgroundColor: Style.greyColor,
        body: Padding(
          padding: const EdgeInsets.all(16.0),
          child: Row(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Expanded(
                child: Container(
                  decoration: BoxDecoration(
                      color: Style.white,
                      borderRadius: BorderRadius.circular(AppConstants.radius)),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      Padding(
                        padding: REdgeInsets.all(16),
                        child: Text(
                          AppHelpers.getTranslation(TrKeys.optionalNotes),
                          style: Style.interMedium(size: 18),
                        ),
                      ),
                      Form(
                        key: _formKey,
                        child: ListView(
                          shrinkWrap: true,
                          padding: EdgeInsets.zero,
                          children: [
                            ListView.builder(
                                physics: const NeverScrollableScrollPhysics(),
                                padding: EdgeInsets.symmetric(
                                    vertical: 12.r, horizontal: 16.r),
                                shrinkWrap: true,
                                itemCount: state.selectMasters.length,
                                itemBuilder: (context, index) {
                                  final selectMaster = state
                                      .selectMasters.values
                                      .elementAt(index);
                                  final errors = state.bookingCalculate?.items
                                          ?.firstWhere(
                                              (element) =>
                                                  element.serviceMaster?.service
                                                      ?.id ==
                                                  selectMaster.serviceMaster
                                                      ?.service?.id,
                                              orElse: () => CalculateItem())
                                          .errors ??
                                      [];
                                  return Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      24.verticalSpace,
                                      Row(
                                        children: [
                                          Expanded(
                                            child: Text(
                                              selectMaster.serviceMaster?.service
                                                      ?.translation?.title ??
                                                  "",
                                              style: Style.interNormal(),
                                            ),
                                          ),
                                          Column(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.end,
                                            children: [
                                              // if ((selectMaster.serviceMaster
                                              //             ?.discount ??
                                              //         0) !=
                                              //     0)
                                              //   Text(
                                              //     AppHelpers.numberFormat(
                                              //       number: selectMaster
                                              //           .serviceMaster?.price,
                                              //     ),
                                              //     style: Style.interNormal(
                                              //         size: 16,
                                              //         textDecoration:
                                              //             TextDecoration
                                              //                 .lineThrough),
                                              //   ),
                                              Text(
                                                AppHelpers.numberFormat(
                                                  number: selectMaster
                                                      .serviceMaster
                                                      ?.totalPrice,
                                                ),
                                                style:
                                                    Style.interNormal(size: 18),
                                              ),
                                            ],
                                          ),
                                        ],
                                      ),
                                      Padding(
                                        padding: EdgeInsets.only(top: 4.r),
                                        child: Text(
                                          errors.toList().join(", "),
                                          style: Style.interNormal(
                                              color: Style.red, size: 12),
                                        ),
                                      ),
                                      8.verticalSpace,
                                      OutlinedBorderTextField(
                                        label: null,
                                        hintText: AppHelpers.getTranslation(
                                            TrKeys.notesAndSpecial),
                                        onChanged: (text) {
                                          notifier.addNote(
                                              note: text, index: index);
                                        },
                                      ),
                                      if (selectMaster
                                              .serviceMaster?.service?.type ==
                                          TrKeys.offlineOut)
                                        Padding(
                                          padding: EdgeInsets.only(top: 8.r),
                                          child: OutlinedBorderTextField(
                                            label: null,
                                            validator: AppValidators.emptyCheck,
                                            hintText: AppHelpers.getTranslation(
                                                TrKeys.address),
                                            onChanged: (text) {
                                              notifier.addAddress(
                                                  address: text, index: index);
                                            },
                                          ),
                                        ),
                                    ],
                                  );
                                }),
                            state.isLoading
                                ? const Loading()
                                : Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      PriceItem(
                                        title: TrKeys.subtotal,
                                        price: state.bookingCalculate?.price,
                                      ),
                                      // PriceItem(
                                      //   title: TrKeys.commissionFee,
                                      //   price: state.calculate?.totalCommissionFee,
                                      // ),
                                      PriceItem(
                                        title: TrKeys.serviceFee,
                                        price: state
                                            .bookingCalculate?.totalServiceFee,
                                      ),
                                      if ((state.bookingCalculate
                                                  ?.totalDiscount ??
                                              0) >
                                          0)
                                        PriceItem(
                                          title: TrKeys.discount,
                                          price: state
                                              .bookingCalculate?.totalDiscount,
                                          discount: true,
                                        ),
                                      Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        mainAxisAlignment:
                                            MainAxisAlignment.start,
                                        children: [
                                          16.verticalSpace,
                                          Padding(
                                            padding: EdgeInsets.symmetric(
                                                horizontal: 16.r),
                                            child: Row(
                                              mainAxisAlignment:
                                                  MainAxisAlignment
                                                      .spaceBetween,
                                              children: [
                                                Text(
                                                  AppHelpers.getTranslation(
                                                      TrKeys.total),
                                                  style: Style.interNormal(
                                                      size: 16),
                                                ),
                                                Text(
                                                  AppHelpers.numberFormat(
                                                      number: state
                                                          .bookingCalculate
                                                          ?.totalPrice),
                                                  style: Style.interNormal(
                                                      size: 16),
                                                ),
                                              ],
                                            ),
                                          ),
                                          if (state.calculate.isNotEmpty)
                                            Padding(
                                              padding:
                                                  const EdgeInsets.all(16.0),
                                              child: Row(
                                                mainAxisAlignment:
                                                    MainAxisAlignment
                                                        .spaceBetween,
                                                children: [
                                                  Text(
                                                    AppHelpers.getTranslation(
                                                        TrKeys.refund),
                                                    style: Style.interNormal(
                                                        size: 16),
                                                  ),
                                                  Text(
                                                    AppHelpers.numberFormat(
                                                        number: (state
                                                                    .bookingCalculate
                                                                    ?.totalPrice ??
                                                                0) -
                                                            (double.tryParse(state
                                                                    .calculate) ??
                                                                0)),
                                                    style: Style.interNormal(
                                                        size: 16),
                                                  ),
                                                ],
                                              ),
                                            )
                                        ],
                                      ),
                                    ],
                                  ),
                            100.verticalSpace,
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
              ),
              16.horizontalSpace,
              Expanded(child: calculator(state, notifier))
            ],
          ),
        ),
        floatingActionButtonLocation: FloatingActionButtonLocation.centerFloat,
        floatingActionButton: Align(
          alignment: Alignment.bottomLeft,
          child: Padding(
            padding: EdgeInsets.symmetric(horizontal: 16.r),
            child: Row(
              children: [
                PopButton(
                  popSuccess: () {
                    if (AppHelpers.getUserRole == TrKeys.master) {
                      ref.read(bookingProvider.notifier).changeStateIndex(3);
                    } else {
                      ref.read(bookingProvider.notifier).changeStateIndex(2);
                    }
                  },
                ),
                10.horizontalSpace,
                SizedBox(
                  height: 56,
                  width: 200,
                  child: CustomButton(
                      title: AppHelpers.getTranslation(TrKeys.next),
                      onTap: () {
                        if (_formKey.currentState?.validate() ?? false) {
                          AppHelpers.showAlertDialog(
                            context: context,
                            child: const BookingPaymentBottomSheet(),
                          );
                          return;
                        }
                      }),
                )
              ],
            ),
          ),
        ),
      ),
    );
  }

  Widget calculator(CreateBookingState state, CreateBookingNotifier notifier) {
    return Expanded(
      child: Container(
        decoration: BoxDecoration(
          color: Style.white,
          borderRadius: BorderRadius.circular(AppConstants.radius),
        ),
        padding: EdgeInsets.symmetric(vertical: 20.r, horizontal: 16.r),
        child: Column(
          children: [
            Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                Row(
                  children: [
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          AppHelpers.getTranslation(TrKeys.payableAmount),
                          style: Style.interMedium(
                            size: 18,
                          ),
                        ),
                        6.verticalSpace,
                        Text(
                          AppHelpers.numberFormat(
                            number: state.selectUser?.wallet?.price ?? 0,
                          ),
                          style: Style.interMedium(size: 24),
                        ),
                      ],
                    )
                  ],
                ),
                16.horizontalSpace,
                if (state.selectUser != null)
                  Expanded(
                    child: Row(
                      children: [
                        CommonImage(
                          url: state.selectUser?.img ?? "",
                          width: 50,
                          height: 50,
                          radius: 25,
                        ),
                        16.horizontalSpace,
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              AutoSizeText(
                                "${state.selectUser?.firstname ?? ""} ${state.selectUser?.lastname ?? ""}",
                                style: Style.interMedium(size: 18),
                                maxLines: 2,
                              ),
                              Text(
                                "#${AppHelpers.getTranslation(TrKeys.id)}${state.selectUser?.id ?? ""}",
                                style: Style.interNormal(
                                    size: 14, color: Style.iconColor),
                              ),
                            ],
                          ),
                        ),
                      ],
                    ),
                  ),
              ],
            ),
            16.verticalSpace,
            const Divider(),
            const Spacer(),
            Container(
              width: double.infinity,
              padding: EdgeInsets.all(20.r),
              decoration: BoxDecoration(
                  border: Border.all(color: Style.differBorderColor),
                  borderRadius: BorderRadius.circular(8.r)),
              child: Align(
                alignment: Alignment.centerRight,
                child: Text(
                  state.calculate,
                  style: Style.interMedium(size: 24),
                  maxLines: 1,
                ),
              ),
            ),
            const Spacer(),
            GridView.builder(
                physics: const NeverScrollableScrollPhysics(),
                itemCount: 12,
                shrinkWrap: true,
                gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                  crossAxisCount: 3,
                  crossAxisSpacing: 28.r,
                  mainAxisSpacing: 24.r,
                  mainAxisExtent: 74.r,
                ),
                itemBuilder: (context, index) {
                  return InkWell(
                    onTap: () {
                      notifier.setCalculate(index == 9
                          ? "00"
                          : index == 10
                              ? "0"
                              : index == 11
                                  ? "-1"
                                  : (index + 1).toString());
                    },
                    child: ButtonEffectAnimation(
                      child: Container(
                        decoration: BoxDecoration(
                          color: Style.addButtonColor,
                          borderRadius: BorderRadius.circular(6.r),
                        ),
                        child: Center(
                          child: index == 11
                              ? const Icon(Remix.delete_back_2_line)
                              : Text(
                                  index == 9
                                      ? "00"
                                      : index == 10
                                          ? "0"
                                          : (index + 1).toString(),
                                  style: Style.interMedium(
                                    size: 24,
                                  ),
                                ),
                        ),
                      ),
                    ),
                  );
                }),
            16.verticalSpace,
            Row(
              children: [
                Expanded(
                  flex: 1,
                  child: InkWell(
                    onTap: () {
                      notifier.setCalculate(".");
                    },
                    child: ButtonEffectAnimation(
                      child: Container(
                        height: 74.r,
                        decoration: BoxDecoration(
                          color: Style.addButtonColor,
                          borderRadius: BorderRadius.circular(6.r),
                        ),
                        child: Center(
                          child: Text(
                            ".",
                            style: Style.interMedium(
                              size: 24,
                            ),
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
                28.horizontalSpace,
                Expanded(
                  flex: 2,
                  child: ButtonEffectAnimation(
                    child: Container(
                      height: 74.r,
                      decoration: BoxDecoration(
                        color: Style.addButtonColor,
                        borderRadius: BorderRadius.circular(6.r),
                      ),
                      child: Center(
                        child: Text(
                          AppHelpers.getTranslation(TrKeys.ok),
                          style: Style.interMedium(
                            size: 24,
                          ),
                        ),
                      ),
                    ),
                  ),
                ),
              ],
            )
          ],
        ),
      ),
    );
  }
}
